import os
import math
import functions

# Task: Energy evaluation for pseudoknots with energy parameters CC09
# Note that Cao & Chen save pseudoknot in format (s1,s2,l1,l3,l2)    
def dic_caochen09(pseudoknot_dic_cc09,matrix_stems):
    pseudoknot_dic_cc09_result = {}
    entropies_dic, entropies_dic_L1, entropies_dic_L3 = {}, {}, {}    
    # Store entropy parameters in dictionary in format (s1,s2,l1,l3,l2)    
    entropies = file("CaoChenParameters.txt",'r')
    for line in entropies:
        i = line.split()
        quintet = int(i[0][3:]),int(i[1][3:]),int(i[2][3:]),int(i[3][3:]),int(i[4][3:])
        entropies_dic[quintet] = float(i[5][3:])
    # For long loops L1 > 7 nt AND L3 <= 7 nt 
    # Store entropy parameters in dictionary in format (s1,s2,'long',l3,l2)
    entropies = file("CaoChenParameters_L1.txt",'r')
    for line in entropies:
        i = line.split()
        a_b = float(i[4][7:]), float(i[5][7:])
        quintet = int(i[0][3:]),int(i[1][3:]),'long',int(i[2][3:]),int(i[3][3:])
        entropies_dic_L1[quintet] = a_b
    # For long loops L3 > 7 nt 
    # Store entropy parameters in dictionary in format (s1,s2,l1,'long',l2)
    entropies = file("CaoChenParameters_L3.txt",'r')
    for line in entropies:
        i = line.split()
        a_b = float(i[4][7:]), float(i[5][7:])
        quintet = int(i[0][3:]),int(i[1][3:]),int(i[2][3:]),'long',int(i[3][3:])
        entropies_dic_L3[quintet] = a_b
        
    for pk_stem in pseudoknot_dic_cc09:
        entropy = 0.0
        i, j, k, l = pk_stem[2], pk_stem[3], pk_stem[5], pk_stem[6]
        stem1 = i, j        
        stemlength1 = pk_stem[4]
        stack_s1 = functions.find_in_dic(matrix_stems,stem1)[2]
        energy_s1 = functions.find_in_dic(matrix_stems,stem1)[3]            
        stem2 = k, l                
        stemlength2 = pk_stem[7]  
        stack_s2 = functions.find_in_dic(matrix_stems,stem2)[2]
        energy_s2 = functions.find_in_dic(matrix_stems,stem2)[3]                            
        l1 = k - (i + stemlength1)
        l2 = (j - stemlength1 + 1) - (k + stemlength2)            
        l3 = (l - stemlength2) - j
        if stemlength1 > 10:
            stemlength1 = 10
        if stemlength2 > 10:
            stemlength2 = 10
                  
        if l1 <= 7 and l3 >= 1 and l3 <= 7:     # L1 <= 7 and 1 <= L3 <= 7        
            quintet = stemlength1,stemlength2,l1,l3,l2
            if functions.find_in_dic(entropies_dic,quintet) != 0.0:
                entropy = functions.find_in_dic(entropies_dic,quintet)            
        if l1 <= 7 and l3 > 7:                  # L1 <= 7 and L3 > 7        
            quintet = stemlength1,stemlength2,l1,'long',l2
            a_b = functions.find_in_dic(entropies_dic_L3,quintet)
            if a_b > 0.0:
                entropy = a_b[0] * math.log(l3) + a_b[1]
        if l1 > 7 and l3 >= 1 and l3 <= 7:      # L1 > 7 and 1 <= L3 <= 7
            quintet = stemlength1,stemlength2,'long',l3,l2                   
            a_b = functions.find_in_dic(entropies_dic_L1,quintet)
            if a_b > 0.0:
                entropy = a_b[0] * math.log(l1) + a_b[1]
        if l1 > 7 and l3 > 7:                   # L1 > 7 and L3 > 7
            quintet = stemlength1,stemlength2,l1,'long',l2
            a_b = functions.find_in_dic(entropies_dic_L3,quintet)
            if a_b > 0.0:
                entropy = a_b[0] * math.log(l3) + a_b[1]
                        
        pk_energy = stack_s1 + stack_s2 - (0.62 * entropy)
                
        if entropy != 0.0:
            if pk_energy < 0.0: 
                if pk_energy < energy_s1 and pk_energy < energy_s2:
                    pseudoknot_dic_cc09_result[pk_stem] = pk_energy, stack_s1, stack_s2, l1, l3, l2, 0.62 * entropy
                    
    return pseudoknot_dic_cc09_result, entropies_dic, entropies_dic_L1, entropies_dic_L3

# Task: Energy re-evaluation for pseudoknots with energy parameters CC09
# Note that Cao & Chen save pseudoknot in format (s1,s2,l1,l3,l2)     
def pk_energy_reevaluation_09(pseudoknot_dic_cc09, matrix_stems, entropies_dic, entropies_dic_L1, entropies_dic_L3):
    pseudoknot_dic_cc09_result = {}
    
    for pk_stem, values in pseudoknot_dic_cc09.items():
        entropy = 0.0
        list1 = values[1]
        list3 = values[3]
        if list1 or list3:
            i, j, k, l = pk_stem[2], pk_stem[3], pk_stem[5], pk_stem[6]
            stemlength1 = pk_stem[4]                        
            stemlength2 = pk_stem[7]                                                              
            l1 = k - (i + stemlength1)
            l2 = (j - stemlength1 + 1) - (k + stemlength2)             
            l3 = (l - stemlength2) - j            
            energy_l1, energy_l3 = 0.0, 0.0
            if stemlength1 > 10:
                stemlength1 = 10
            if stemlength2 > 10:
                stemlength2 = 10
            effective_l1 = l1
            effective_l3 = l3
            
            if list1:   # Calculate effective loop length
                effective_l1 = l1
                for item in sorted(list1):
                    effective_l1 = effective_l1 - (item[1] - item[0] + 1)                    
                    effective_l1 = effective_l1 + 1     # Plus number of helices                       
                    energy_l1 = energy_l1 + item[5]                 
                                                   
            if list3:   # Calculate effective loop length
                effective_l3 = l3
                for item in sorted(list3):
                    effective_l3 = effective_l3 - (item[1] - item[0] + 1)                    
                    effective_l3 = effective_l3 + 1     # Plus number of helices                       
                    energy_l3 = energy_l3 + item[5]              
            
            if effective_l1 <= 7 and effective_l3 <= 7:   # L1 <= 7 and L3 <= 7
                quintet = stemlength1,stemlength2,effective_l1,effective_l3,l2
                if functions.find_in_dic(entropies_dic,quintet) != 0.0:
                    entropy = functions.find_in_dic(entropies_dic,quintet)
            if effective_l1 <= 7 and effective_l3 > 7:    # L1 <= 7 and L3 > 7                    
                quintet = stemlength1,stemlength2,effective_l1,'long',l2
                a_b = functions.find_in_dic(entropies_dic_L3,quintet)
                if a_b > 0.0:
                    entropy = a_b[0] * math.log(effective_l3) + a_b[1]
            if effective_l1 > 7 and effective_l3 <= 7:   # L1 > 7 and L3 <= 7                        
                quintet = stemlength1,stemlength2,'long',effective_l3,l2                   
                a_b = functions.find_in_dic(entropies_dic_L1,quintet)
                if a_b > 0.0:
                    entropy = a_b[0] * math.log(effective_l1) + a_b[1]                          
            if effective_l1 > 7 and effective_l3 > 7:   # L1 > 7 and L3 > 7     
                quintet = stemlength1,stemlength2,effective_l1,'long',l2
                a_b = functions.find_in_dic(entropies_dic_L3,quintet)
                if a_b > 0.0:
                    entropy = a_b[0] * math.log(l3) + a_b[1]

            stack_s1 = values[0][1]
            stack_s2 = values[0][2]   
            pk_energy = stack_s1 + stack_s2 - (0.62 * entropy) + energy_l1 + energy_l3 
            
            if entropy != 0.0:
                if pk_energy < 0.0:
                    if pk_energy < values[0][0]:                 
                        pseudoknot_dic_cc09_result[pk_stem] = pk_energy, values[1], values[2], values[3]
                    else:
                        pseudoknot_dic_cc09[pk_stem] = values[0][0], [], [], []                            
        else:
            pk_energy = pseudoknot_dic_cc09[pk_stem][0][0]
            pseudoknot_dic_cc09_result[pk_stem] = pk_energy, values[1], values[2], values[3]                
    return pseudoknot_dic_cc09_result
