# Task: Function for key search in a dictionary
# Return value 0.0 if there is no such key in dictionary
def find_in_dic(matrix,key):
    if key in matrix:
        return matrix[key]
    else:
        return 0.0
    
# Task: Maximum weight independent set calculation
# Step 1, initialization
# Step 2, scan sorted endpoints list
# Step 3, traceback step
def MWIS(interval_set, sorted_endpointlist):
    value, temp_max, Smax1, last_interval = [], 0.0, [], 0
    for j in xrange(len(sorted_endpointlist)):    # Step 1
        value.insert(j,0.0)
    for endpoint in sorted_endpointlist:          # Step 2
        if endpoint[1] == 'l':                    # If left endpoint is scanned
            c = endpoint[3] - 1
            value[c] = temp_max + endpoint[2]            
        if endpoint[1] == 'r':                    # If right endpoint is scanned
            c = endpoint[3] - 1
            if value[c] > temp_max:
                temp_max = value[c]
                last_interval = c
    Smax1.insert(0,interval_set[last_interval])
    temp_max = temp_max - interval_set[last_interval][4]    
    for j in xrange(last_interval-1,-1,-1):       # Step 3
        if round(value[j], 2) == round(temp_max, 2):            
            if interval_set[j][1] < interval_set[last_interval][0]:                
                Smax1.append(interval_set[j])
                temp_max = temp_max - interval_set[j][4]
                last_interval = j
    return Smax1

# Task: Create sorted endpoints list for a set of intervals
# If two intervals share the same endpoint where one is a right and one is a left endpoint, 
# scan left endpoint before the right endpoint 
def create_sorted_endpointlist(intervals):
    sorted_list, firstpoint, secondpoint = [], (), ()
    for i in xrange(len(intervals)):
        firstpoint = (intervals[i][0],'l',float(intervals[i][4]),i+1)
        sorted_list.append(firstpoint)
        secondpoint = (intervals[i][1],'r',float(intervals[i][4]),i+1)
        sorted_list.append(secondpoint)        
    sorted_list.sort()
    for i in xrange(len(sorted_list)-1):        
        j = i + 1        
        while int(sorted_list[i][0]) == int(sorted_list[j][0]):
            if sorted_list[i][1] > sorted_list[j][1]:       # Case r > l            
                temp = sorted_list[i]                       # Swap endpoints
                sorted_list[i] = sorted_list[j]             # Left endpoints first,
                sorted_list[j] = temp                       # than right endpoints
            if j + 1 < len(sorted_list) - 1:
                j = j + 1
            else:
                break
    return sorted_list
