import os
import sys
import math  
import functions
    
# Task: Construct core H-type pseudoknots with regular stems
# Return core H-type pseudoknot dictionary and dictionary which holds the shortened stems
def build_pseudoknots(matrix_stems):
    pseudoknot_dic, stems_shortened = {}, {}
    matrix_stems_list =  matrix_stems.items()
    matrix_stems_list.sort()                        
    for x in xrange(len(matrix_stems_list)):
        for y in xrange(x,len(matrix_stems_list)):
            i, j = matrix_stems_list[x][0][0], matrix_stems_list[x][0][1]
            key1 = i, j
            stemlength1 = functions.find_in_dic(matrix_stems,key1)[0]
            stack_energy1 = functions.find_in_dic(matrix_stems,key1)[2]      
            k, l = matrix_stems_list[y][0][0], matrix_stems_list[y][0][1]
            key2 = k, l            
            stemlength2 = functions.find_in_dic(matrix_stems,key2)[0]
            stack_energy2 = functions.find_in_dic(matrix_stems,key2)[2]
            l1 = k - (i + stemlength1)            
            l2 = (j - stemlength1 + 1) - (k + stemlength2)
            l3 = (l - stemlength2) - j 
            
            if (stack_energy1 + stack_energy2) < -12.0 and (l - i + 1) > 15:
                if l2 >= 0 and l2 < 50:                               
                    if l1 >= 1 and l1 < 100:
                        if l3 >= 2 and l3 < 100:                                           
                            key = i, l, i, j, stemlength1, k, l, stemlength2, 'r'                                 
                            pseudoknot_dic[key] = 0.0
                # Case that overlap of 1 bp occurs at L2
                elif l2 == -1 and (stemlength1 > 3 or stemlength2 > 3):
                    if l1 == 0 and stemlength1 > 3:        # Cut S1 
                        stemlength1, l1, l2 = stemlength1 - 1, l1 + 1, l2 + 1                            
                    elif l3 == 1 and stemlength2 > 3:      # Cut S2 
                        stemlength2, l2, l3 = stemlength2 - 1, l2 + 1, l3 + 1                              
                    elif l1 >= 1 and l3 >= 2 and l2 == -1:
                        if stemlength1 > 3:                 # Cut S1
                            stemlength1, l1, l2 = stemlength1 - 1, l1 + 1, l2 + 1                   
                        elif stemlength2 > 3:               # Cut S2
                            stemlength2, l2, l3 = stemlength2 - 1, l2 + 1, l3 + 1                                                       
                    if l2 >= 0 and l2 < 50:
                        if l1 >= 1 and l1 < 100:
                            if l3 >= 2 and l3 < 100:
                                key = i, l, i, j, stemlength1, k, l, stemlength2, 'r'                                
                                pseudoknot_dic[key] = 0.0                              
                                s1_shortended = i, j, stemlength1     
                                key = i, j
                                original_length = functions.find_in_dic(matrix_stems,key)[0]
                                if stemlength1 != original_length:
                                    stems_shortened[s1_shortended] = 0.0    # Add shortened stem to dictionary                                        
                                s2_shortended = k,l,stemlength2
                                key = k, l
                                original_length = functions.find_in_dic(matrix_stems,key)[0]
                                if stemlength2 != original_length:
                                    stems_shortened[s2_shortended] = 0.0    # Add shortened stem to dictionary                                                                                                      
                # Case that overlap of 2 bp occurs at L2                                    
                elif l2 == -2 and (stemlength1 > 3 or stemlength2 > 3):
                    marker = 0
                    while l2 != 0:
                        if l1 == 0:        
                            if stemlength1 > 3:     # Cut S1
                                stemlength1, l1, l2 = stemlength1 - 1, l1 + 1, l2 + 1                                    
                            else:
                                l2 = 0
                        elif l3 == 1:      
                            if stemlength2 > 3:     # Cut S2
                                stemlength2, l2, l3 = stemlength2 - 1, l2 + 1, l3 + 1                                  
                            else:
                                l2 = 0
                        elif l1 >= 1 and l3 >= 2 and l2 < 0:
                            if stemlength1 > 3:     # Cut S1
                                stemlength1, l1, l2 = stemlength1 - 1, l1 + 1, l2 + 1                                      
                            elif stemlength2 > 3:   # Cut S2
                                stemlength2, l2, l3 = stemlength2 - 1, l2 + 1, l3 + 1                                  
                            else:
                                l2, marker = 0, 1   # It is not possible to resolve the overlap
                        else:
                            l2, marker = 0, 1       # It is not possible to resolve the overlap
                    if l2 >= 0 and l2 < 50 and marker == 0:
                        if l1 >= 1 and l1 < 100:
                            if l3 >= 2 and l3 < 100:
                                key = i, l, i, j, stemlength1, k, l, stemlength2, 'r'                                  
                                pseudoknot_dic[key] = 0.0
                                s1_shortended = i,j,stemlength1
                                key = i, j
                                original_length = functions.find_in_dic(matrix_stems,key)[0]
                                if stemlength1 != original_length:
                                    stems_shortened[s1_shortended] = 0.0    # Add shortened stem to dictionary                                            
                                s2_shortended = k,l,stemlength2
                                key = k, l
                                original_length = functions.find_in_dic(matrix_stems,key)[0]
                                if stemlength2 != original_length:
                                    stems_shortened[s2_shortended] = 0.0    # Add shortened stem to dictionary                                                    
    return stems_shortened,pseudoknot_dic

hairpin_dic = {
 0: 0.0 ,   1: 0.0 , 2: 0.0,  3: 4.1,  4: 4.9,  5: 4.4,  6: 4.7,  7: 5.0,  8: 5.1,  9: 5.2, 10: 5.3,
11: 5.4 , 12: 5.5 , 13: 5.6, 14: 5.7, 15: 5.8, 16: 5.8, 17: 5.9, 18: 5.9, 19: 6.0, 20: 6.1, 21: 6.1,
22: 6.2 , 23: 6.2 , 24: 6.3, 25: 6.3, 26: 6.3, 27: 6.4, 28: 6.4, 29: 6.5, 30: 6.5
}

# Task: Construct core H-type pseudoknots with one interrupted stem
# s_i + s_ib or s_ib + s_i
# Return core H-type pseudoknot dictionary and dictionary which holds the shortened stems
def pseudoknots_with_IB(bulge_internal_dic, matrix_stems):
    pk_with_IB = {}    
    stems_shortened_ib = {}
    for stem_ib, values_ib in bulge_internal_dic.items():
        structure = values_ib[1]            # :((((.(((((.....))))).))))                    
        left = structure.rfind('(') - 1     # Position of last bracket '(' 
        right = structure.find(')') - 1     # Position of first bracket ')'     
        if stem_ib[0] == 1:                 # Case of dangling end 
            left = left + 1
            right = right + 1
        hairpin_loop = len(structure[left:right])-1
        if hairpin_loop > 30:
            hairpin_loop = 30
        entropy = hairpin_dic[hairpin_loop]        
        left_index = stem_ib[0] + left        
        right_index = stem_ib[0] + right - 1
        stemlength_left  = left_index - stem_ib[0] + 1
        stemlength_right = stem_ib[1] - right_index 

        for stem, values in matrix_stems.items():                
            if values_ib[2] - entropy + values[2] < -12.0:
                length = values[0]
                # First Case, combine s_ib with normal stem s
                # (((...((((.xxx...))))...)))........xxx
                #          L1    L2             L3               
                if stem[0] >= left_index:
                    if stem[0] + length - 1 <= right_index + 1:     # Allow overlap of 1 nt
                        if stem[1] - length + 1 > stem_ib[1]:
                            l1 = stem[0] - (stem_ib[0] + left) - 1
                            l2 = (stem_ib[0] + right) - (stem[0] + length)
                            l3 = (stem[1] - length) - stem_ib[1]                               
                            if l2 >= 0 and l2 < 50:
                                if l1 >= 1 and l1 < 100:                                    
                                    if l3 >= 2 and l3 < 100:
                                        key = stem_ib[0], stem[1], stem_ib[0], stem_ib[1], values_ib[0], stem[0], stem[1], length, 'iS1'
                                        stem_length_eff = structure.rfind(')') - right + 1                                        
                                        energy_sum = values_ib[2] + values[2]
                                        pk_with_IB[key] = energy_sum, values_ib[2], l1, l2, l3, hairpin_loop, left, right, values[3], stemlength_left, stemlength_right 
                            # Case that overlap of 1 bp occurs at loop L2
                            # (((...((((......))))...)))
                            # ............xxxxx............xxxxx                                       
                            elif l2 == -1 and length > 3:                          
                                length = length - 1     # Cut regular stem S2
                                l2 = l2 + 1
                                l3 = l3 + 1
                                if l2 >= 0 and l2 < 50:
                                    if l1 >= 1 and l1 < 100:                                    
                                        if l3 >= 2 and l3 < 100:
                                            key = stem_ib[0], stem[1], stem_ib[0], stem_ib[1], values_ib[0], stem[0], stem[1], length, 'iS1'
                                            stem_length_eff = structure.rfind(')') - right + 1
                                            energy_sum = values_ib[2] + values[2]
                                            pk_with_IB[key] = energy_sum, values_ib[2], l1, l2, l3, hairpin_loop, left, right, values[3], stemlength_left, stemlength_right
                                            s2_shortended = stem[0],stem[1],length
                                            stems_shortened_ib[s2_shortended] = 0.0  
                # Second Case, combine normal stem s with s_ib
                # xxx........(((...((((.xxx...))))...)))
                #       L1             L2   L3
                elif stem[0] < stem_ib[0]:
                    if stem[1] <= right_index:                  
                        if stem[1] - length + 1 >= left_index - 1:      # Allow overlap of 1 nt
                            l1 = stem_ib[0] - (stem[0] + length)
                            l2 = (stem[1] - length) - (stem_ib[0] + left)
                            l3 = (stem_ib[0] + right) - stem[1] - 1
                            if l2 >= 0 and l2 < 50:
                                if l1 >= 1 and l1 < 100:                                    
                                    if l3 >= 2 and l3 < 100:                                        
                                        key = stem[0], stem_ib[1], stem[0], stem[1], length, stem_ib[0], stem_ib[1], values_ib[0], 'iS2'
                                        stem_length_eff = left
                                        energy_sum = values_ib[2] + values[2]
                                        pk_with_IB[key] = energy_sum, values_ib[2], l1, l2, l3, hairpin_loop, left, right, values[3], stemlength_left, stemlength_right
                            # Case that overlap of 1 bp occurs at loop L2
                            # ((((............))))
                            # .......xxx..xxxxx........xxxx..xxxxx                                       
                            elif l2 == -1 and length > 3:                                
                                length = length - 1     # Cut regular stem S1                                    
                                l1 = l1 + 1
                                l2 = l2 + 1                                    
                                if l2 >= 0 and l2 < 50:
                                    if l1 >= 1 and l1 < 100:                                    
                                        if l3 >= 2 and l3 < 100:
                                            key = stem[0], stem_ib[1], stem[0], stem[1], length, stem_ib[0], stem_ib[1], values_ib[0], 'iS2'
                                            stem_length_eff = left
                                            energy_sum = values_ib[2] + values[2]
                                            pk_with_IB[key] = energy_sum, values_ib[2], l1, l2, l3, hairpin_loop, left, right, values[3], stemlength_left, stemlength_right
                                            s1_shortended = stem[0],stem[1],length
                                            stems_shortened_ib[s1_shortended] = 0.0
    return stems_shortened_ib, pk_with_IB

# Task: Scan pseudoknot dictionary and create three new dictionaries,
# according to interhelix loop size
def pk_dic_scan(pseudoknot_dic,matrix_stems,stems_shortened):
    pseudoknot_dic_cc06 = {}
    pseudoknot_dic_cc09 = {}
    pseudoknot_dic_longpk = {}

    for pk_stem in pseudoknot_dic:
        i, j, k, l = pk_stem[2], pk_stem[3], pk_stem[5], pk_stem[6]        
        stem1 = i, j
        stemlength1 = functions.find_in_dic(matrix_stems,stem1)[0]                
        if stemlength1 != pk_stem[4]:     # Look up if S1 is a shortened stem            
            stemlength1 = pk_stem[4]
            stem1 = i, j, pk_stem[4]
            # If not found, the shortened stem was deleted before because of high free energy
            if functions.find_in_dic(stems_shortened,stem1) != 0.0:
                energy_s1 = functions.find_in_dic(stems_shortened,stem1)[2]
            else:
                energy_s1 = 100
        else:     
            energy_s1 = functions.find_in_dic(matrix_stems,stem1)[2]
            
        stem2 = k, l                
        stemlength2 = functions.find_in_dic(matrix_stems,stem2)[0]        
        if stemlength2 != pk_stem[7]:     # Look up if S2 is a shortened stem            
            stemlength2 = pk_stem[7]
            stem2 = k, l, pk_stem[7]
            # If not found, the shortened stem was deleted before because of high free energy
            if functions.find_in_dic(stems_shortened,stem2) != 0.0:            
                energy_s2 = functions.find_in_dic(stems_shortened,stem2)[2]
            else:
                energy_s2 = 100
        else:     
            energy_s2 = functions.find_in_dic(matrix_stems,stem2)[2]
                                   
        l1 = k - (i + stemlength1)
        l2 = (j - stemlength1 + 1) - (k + stemlength2)            
        l3 = (l - stemlength2) - j 
            
        if energy_s1 != 100 and energy_s2 != 100:
            if l2 <= 1:
                pseudoknot_dic_cc06[pk_stem] = 0.0
            else:
                if l2 < 7: 
                    pseudoknot_dic_cc09[pk_stem] = 0.0
                else:
                    pseudoknot_dic_longpk[pk_stem] = 0.0
    return pseudoknot_dic_cc06,pseudoknot_dic_cc09,pseudoknot_dic_longpk
