import functions

# Scan the dictionary of pseudoknots and output the x best
# pseudoknots in terms of energy to length ratio
def output_best_ratio(pk_recursive_dic, number_of_best_pks):    
    candidates = pk_recursive_dic.copy()
    best_pks = []
    
    for i in xrange(number_of_best_pks):
        minimum = 0.0
        if candidates:    
            for pk, values in candidates.items():
                length_pk = pk[1] - pk[0] + 1
                energy_pk = values[0]
                ratio = energy_pk/length_pk                
                if ratio < minimum:
                    minimum = ratio
                    best_pk = pk
            best_pks.append(best_pk)
            del candidates[best_pk]                   
        
    return best_pks

# Scan the dictionary of pseudoknots and output the x best
# pseudoknots in terms of energy to length ratio
def output_best_ratio_khp(pk_not_filtered, best_khps, number_of_best_pks):    
    candidates = pk_not_filtered.copy()
    best_pks = []
    
    if best_khps:
        for khp in best_khps:
            stems = best_khps[khp][0]
            result = best_khps[khp][1:]
            candidates[khp] = result    
    
    for i in xrange(number_of_best_pks):
        minimum = 0.0
        if candidates:    
            for pk, values in candidates.items():
                length_pk = pk[1] - pk[0] + 1
                energy_pk = values[0]
                ratio = energy_pk/length_pk                
                if ratio < minimum:
                    minimum = ratio
                    best_pk = pk
            best_pks.append(best_pk)
            del candidates[best_pk]                   
        
    return best_pks

# Scan the dictionary of pseudoknots and output the x best
# pseudoknots in terms of absolute free energy
def output_best_energy(pk_recursive_dic, number_of_best_pks):    
    candidates = pk_recursive_dic.copy()
    best_pks = []
    
    for i in xrange(number_of_best_pks):
        minimum = 0.0
        if candidates:    
            for pk, values in candidates.items():
                energy_pk = values[0]
                if energy_pk < minimum:
                    minimum = energy_pk
                    best_pk = pk
            best_pks.append(best_pk)
            del candidates[best_pk]                   
        
    return best_pks

# Scan the dictionary of pseudoknots and output the x best
# pseudoknots in terms of absolute free energy
def output_best_energy_khp(pk_not_filtered, best_khps, number_of_best_pks):    
    candidates = pk_not_filtered.copy()
    best_pks = []
    
    if best_khps:
        for khp in best_khps:
            stems = best_khps[khp][0]
            result = best_khps[khp][1:]
            candidates[khp] = result
    
    for i in xrange(number_of_best_pks):
        minimum = 0.0
        if candidates:    
            for pk, values in candidates.items():
                energy_pk = values[0]
                if energy_pk < minimum:
                    minimum = energy_pk
                    best_pk = pk
            best_pks.append(best_pk)
            del candidates[best_pk]                   
                
    return best_pks

# Task: Print structures for pseudoknots with both regular and interrupted stems
def pk_structures(seq, best_pks, matrix_stems, stems_shortened_dic, bulge_internal_dic, multiloops, pk_recursive_dic, best_khps):
    pseudoknot_list = []    
    for pk in best_pks:
        # Kissing hairpin 
        if len(pk) == 2:            
            kissing_hairpin = best_khps[pk][0]
            i, j, stemlength1 = kissing_hairpin[0][0], kissing_hairpin[0][1], kissing_hairpin[1]
            k, l, stemlength2 = kissing_hairpin[2][0], kissing_hairpin[2][1], kissing_hairpin[3]
            m, n, stemlength3 = kissing_hairpin[4][0], kissing_hairpin[4][1], kissing_hairpin[5]            
            energy = round(best_khps[pk][1],2)
            recursive_loop1 = best_khps[pk][2]
            recursive_loop2 = best_khps[pk][3]
            recursive_loop3 = best_khps[pk][4]
            recursive_loop4 = best_khps[pk][5]
            recursive_loop5 = best_khps[pk][6]            
                                                   
            L1_start = kissing_hairpin[0][0] + kissing_hairpin[1]
            L1_end = kissing_hairpin[2][0] - 1
            l1 = L1_end - L1_start + 1        
            L2_start = kissing_hairpin[2][0] + kissing_hairpin[3]
            L2_end = kissing_hairpin[0][1] - kissing_hairpin[1]
            l2 = L2_end - L2_start + 1      
            L3_start = kissing_hairpin[0][1] + 1
            L3_end = kissing_hairpin[4][0] - 1
            l3 = L3_end - L3_start + 1             
            L4_start = kissing_hairpin[4][0] + kissing_hairpin[5]
            L4_end = kissing_hairpin[2][1] - kissing_hairpin[3]
            l4 = L4_end - L4_start + 1       
            L5_start = kissing_hairpin[2][1] + 1
            L5_end = kissing_hairpin[4][1] - kissing_hairpin[5]
            l5 = L5_end - L5_start + 1

            pk_seq = seq[int(i-1):int(n)]

            pk_structure = ''
            for x in xrange(stemlength1):
                pk_structure = pk_structure + '('
            for x in xrange(l1):
                pk_structure = pk_structure + '.'
            for x in xrange(stemlength2):
                pk_structure = pk_structure + '['
            for x in xrange(l2):
                pk_structure = pk_structure + '.'
            for x in xrange(stemlength1):
                pk_structure = pk_structure + ')'
            for x in xrange(l3):
                pk_structure = pk_structure + '.'
            for x in xrange(stemlength3):
                pk_structure = pk_structure + '('
            for x in xrange(l4):
                pk_structure = pk_structure + '.'            
            for x in xrange(stemlength2):
                pk_structure = pk_structure + ']'
            for x in xrange(l5):
                pk_structure = pk_structure + '.'            
            for x in xrange(stemlength3):
                pk_structure = pk_structure + ')'

            # Now add recursive structure elements
            if recursive_loop1:
                pk_structure = recursive_elements(recursive_loop1, pk_structure, i, bulge_internal_dic, multiloops)
            if recursive_loop2:
                pk_structure = recursive_elements(recursive_loop2, pk_structure, i, bulge_internal_dic, multiloops)
            if recursive_loop3:
                pk_structure = recursive_elements(recursive_loop3, pk_structure, i, bulge_internal_dic, multiloops)
            if recursive_loop4:
                pk_structure = recursive_elements(recursive_loop4, pk_structure, i, bulge_internal_dic, multiloops)
            if recursive_loop5:
                pk_structure = recursive_elements(recursive_loop5, pk_structure, i, bulge_internal_dic, multiloops)
                                        
            pseudoknot = [i, n, energy, 'khp', pk_seq, pk_structure]             
            pseudoknot_list.append(pseudoknot)

        else:
            # Note the different pk format
            i, j, stemlength1 = pk[2], pk[3], pk[4]        
            k, l, stemlength2 = pk[5], pk[6], pk[7]
            marker = pk[8]
            key = i, l, i, j, stemlength1, k, l, stemlength2, marker                            
            # Find the recursive structure elements            
            if marker == 'r':
                energy = round(pk_recursive_dic[key][0],2)
                recursive_loop1 = pk_recursive_dic[key][1]
                recursive_loop2 = pk_recursive_dic[key][2]
                recursive_loop3 = pk_recursive_dic[key][3]
                # Now assemble the core pseudoknot structure with regular stems
                looplength1 = k - (i + stemlength1)            
                looplength2 = (j - stemlength1 + 1) - (k + stemlength2)
                looplength3 = (l - stemlength2) - j
                pk_seq = seq[int(i-1):int(l)]
                pk_structure = ''
                for x in xrange(stemlength1):
                    pk_structure = pk_structure + '('
                for x in xrange(looplength1):
                    pk_structure = pk_structure + '.'
                for x in xrange(stemlength2):
                    pk_structure = pk_structure + '['
                for x in xrange(looplength2):
                    pk_structure = pk_structure + '.'
                for x in xrange(stemlength1):
                    pk_structure = pk_structure + ')'
                for x in xrange(looplength3):
                    pk_structure = pk_structure + '.'
                for x in xrange(stemlength2):
                    pk_structure = pk_structure + ']'
            else:
                energy = round(pk_recursive_dic[key][0],2)
                # Now assemble the core pseudoknot structure with one interrupted stem            
                recursive_loop1 = pk_recursive_dic[key][1]
                recursive_loop2 = pk_recursive_dic[key][2]
                recursive_loop3 = pk_recursive_dic[key][3]                
                looplength1 = k - (i + stemlength1)            
                looplength2 = (j - stemlength1 + 1) - (k + stemlength2)
                looplength3 = (l - stemlength2) - j 
                pk_seq = seq[int(i-1):int(l)]
                pk_structure = ''            
                # Case 1: stem S1 is interrupted
                if marker == 'iS1':
                    stem1 = i,j
                    structure_stem1 = functions.find_in_dic(bulge_internal_dic,stem1)[1]             
                    # Delete dangling ends ':'
                    structure_stem1 = structure_stem1.replace(':','')
                    pk_structure = pk_structure + structure_stem1                       
                    # Start of stem S2                                 
                    start = k - i               
                    for x in xrange(stemlength2):
                        pk_structure = pk_structure[0:start] + '[' + pk_structure[start+1:]
                        start = start + 1
                    for x in xrange(looplength3):
                        pk_structure = pk_structure + '.'                    
                    for x in xrange(stemlength2):
                        pk_structure = pk_structure + ']'                                
                # Case 2: stem S2 is interrupted, change brackets '(' to '[' and ')' to ']'
                if marker == 'iS2':
                    stem2 = k,l
                    structure_stem2 = functions.find_in_dic(bulge_internal_dic,stem2)[1]                   
                    # Delete dangling ends ':'
                    structure_stem2 = structure_stem2.replace(':','')
                    structure_stem2 = structure_stem2.replace('(','[')
                    structure_stem2 = structure_stem2.replace(')',']')                
                    pk_structure = pk_structure + structure_stem2
                    for x in xrange(looplength1):
                        pk_structure = '.' + pk_structure                
                    for x in xrange(stemlength1):
                        pk_structure = '(' + pk_structure
                    # End of stem S1
                    end = j-i
                    for x in xrange(stemlength1):
                        pk_structure = pk_structure[0:end] + ')' + pk_structure[end+1:]
                        end = end - 1
            # Now add recursive structure elements
            if recursive_loop1:
                for element in recursive_loop1:
                    element_length = element[2] + 1
                    start = element[0] - i
                    end = element[1] - i
                    if element[6] == 'hp':                                       
                        for counter in xrange(1,element_length):
                            pk_structure = pk_structure[0:start] + '(' + pk_structure[start+1:]
                            pk_structure = pk_structure[0:end] + ')' + pk_structure[end+1:]
                            start = start + 1
                            end = end - 1
                    elif element[6] == 'ib':
                        structure_ib = bulge_internal_dic[element[0],element[1]][1]                    
                        structure_ib = structure_ib.replace(':','') # Cut off dangling ends
                        pk_structure = pk_structure[0:start] + structure_ib + pk_structure[end+1:]                
                    elif element[6] == 'ml':
                        structure_ml = multiloops[element[0],element[1]][1]                    
                        structure_ml = structure_ml.replace(':','') # Cut off dangling ends
                        pk_structure = pk_structure[0:start] + structure_ml + pk_structure[end+1:]
            if recursive_loop2:
                for element in recursive_loop2:
                    element_length = element[2] + 1
                    start = element[0] - i
                    end = element[1] - i             
                    if element[6] == 'hp':                                       
                        for counter in xrange(1,element_length):
                            pk_structure = pk_structure[0:start] + '(' + pk_structure[start+1:]
                            pk_structure = pk_structure[0:end] + ')' + pk_structure[end+1:]
                            start = start + 1
                            end = end - 1
                    elif element[6] == 'ib':                        
                        structure_ib = bulge_internal_dic[element[0],element[1]][1]                    
                        structure_ib = structure_ib.replace(':','') # Cut off dangling ends
                        pk_structure = pk_structure[0:start] + structure_ib + pk_structure[end+1:]
                    elif element[6] == 'ml':
                        structure_ml = multiloops[element[0],element[1]][1]                    
                        structure_ml = structure_ml.replace(':','') # Cut off dangling ends
                        pk_structure = pk_structure[0:start] + structure_ml + pk_structure[end+1:]
            if recursive_loop3:
                for element in recursive_loop3:
                    element_length = element[2] + 1
                    start = element[0] - i
                    end = element[1] - i               
                    if element[6] == 'hp':                   
                        for counter in xrange(1,element_length):
                            pk_structure = pk_structure[0:start] + '(' + pk_structure[start+1:]
                            pk_structure = pk_structure[0:end] + ')' + pk_structure[end+1:]
                            start = start + 1
                            end = end - 1
                    elif element[6] == 'ib':                        
                        structure_ib = bulge_internal_dic[element[0],element[1]][1]
                        structure_ib = structure_ib.replace(':','') # Cut off dangling ends
                        pk_structure = pk_structure[0:start] + structure_ib + pk_structure[end+1:]
                    elif element[6] == 'ml':
                        structure_ml = multiloops[element[0],element[1]][1]                    
                        structure_ml = structure_ml.replace(':','') # Cut off dangling ends
                        pk_structure = pk_structure[0:start] + structure_ml + pk_structure[end+1:]                      
            pseudoknot = [i, l, energy, pk_seq, pk_structure]             
            pseudoknot_list.append(pseudoknot)                                          
    return pseudoknot_list    

# Task: Print structures for pseudoknots with both regular and interrupted stems
def pk_khp_structures(seq, best_pks, matrix_stems, stems_shortened_dic, bulge_internal_dic, multiloops, pk_not_filtered, best_khps):
    pseudoknot_list = []    
    for pk in best_pks:
        # Kissing hairpin 
        if len(pk) == 2:            
            kissing_hairpin = best_khps[pk][0]
            i, j, stemlength1 = kissing_hairpin[0][0], kissing_hairpin[0][1], kissing_hairpin[1]
            k, l, stemlength2 = kissing_hairpin[2][0], kissing_hairpin[2][1], kissing_hairpin[3]
            m, n, stemlength3 = kissing_hairpin[4][0], kissing_hairpin[4][1], kissing_hairpin[5]            
            energy = round(best_khps[pk][1],2)
            recursive_loop1 = best_khps[pk][2]
            recursive_loop2 = best_khps[pk][3]
            recursive_loop3 = best_khps[pk][4]
            recursive_loop4 = best_khps[pk][5]
            recursive_loop5 = best_khps[pk][6]            
                                                   
            L1_start = kissing_hairpin[0][0] + kissing_hairpin[1]
            L1_end = kissing_hairpin[2][0] - 1
            l1 = L1_end - L1_start + 1        
            L2_start = kissing_hairpin[2][0] + kissing_hairpin[3]
            L2_end = kissing_hairpin[0][1] - kissing_hairpin[1]
            l2 = L2_end - L2_start + 1      
            L3_start = kissing_hairpin[0][1] + 1
            L3_end = kissing_hairpin[4][0] - 1
            l3 = L3_end - L3_start + 1             
            L4_start = kissing_hairpin[4][0] + kissing_hairpin[5]
            L4_end = kissing_hairpin[2][1] - kissing_hairpin[3]
            l4 = L4_end - L4_start + 1       
            L5_start = kissing_hairpin[2][1] + 1
            L5_end = kissing_hairpin[4][1] - kissing_hairpin[5]
            l5 = L5_end - L5_start + 1

            pk_seq = seq[int(i-1):int(n)]

            pk_structure = ''
            for x in xrange(stemlength1):
                pk_structure = pk_structure + '('
            for x in xrange(l1):
                pk_structure = pk_structure + '.'
            for x in xrange(stemlength2):
                pk_structure = pk_structure + '['
            for x in xrange(l2):
                pk_structure = pk_structure + '.'
            for x in xrange(stemlength1):
                pk_structure = pk_structure + ')'
            for x in xrange(l3):
                pk_structure = pk_structure + '.'
            for x in xrange(stemlength3):
                pk_structure = pk_structure + '('
            for x in xrange(l4):
                pk_structure = pk_structure + '.'            
            for x in xrange(stemlength2):
                pk_structure = pk_structure + ']'
            for x in xrange(l5):
                pk_structure = pk_structure + '.'            
            for x in xrange(stemlength3):
                pk_structure = pk_structure + ')'

            # Now add recursive structure elements
            if recursive_loop1:
                pk_structure = recursive_elements(recursive_loop1, pk_structure, i, bulge_internal_dic, multiloops)
            if recursive_loop2:
                pk_structure = recursive_elements(recursive_loop2, pk_structure, i, bulge_internal_dic, multiloops)
            if recursive_loop3:
                pk_structure = recursive_elements(recursive_loop3, pk_structure, i, bulge_internal_dic, multiloops)
            if recursive_loop4:
                pk_structure = recursive_elements(recursive_loop4, pk_structure, i, bulge_internal_dic, multiloops)
            if recursive_loop5:
                pk_structure = recursive_elements(recursive_loop5, pk_structure, i, bulge_internal_dic, multiloops)
                                        
            pseudoknot = [i, n, energy, 'khp', pk_seq, pk_structure]             
            pseudoknot_list.append(pseudoknot)

        else:
            # Note the different pk format
            i, j, stemlength1 = pk[2], pk[3], pk[4]        
            k, l, stemlength2 = pk[5], pk[6], pk[7]
            marker = pk[8]
            key = i, l, i, j, stemlength1, k, l, stemlength2, marker                            
            # Find the recursive structure elements            
            if marker == 'r':
                energy = round(pk_not_filtered[key][0],2)
                recursive_loop1 = pk_not_filtered[key][1]
                recursive_loop2 = pk_not_filtered[key][2]
                recursive_loop3 = pk_not_filtered[key][3]
                # Now assemble the core pseudoknot structure with regular stems
                looplength1 = k - (i + stemlength1)            
                looplength2 = (j - stemlength1 + 1) - (k + stemlength2)
                looplength3 = (l - stemlength2) - j
                pk_seq = seq[int(i-1):int(l)]
                pk_structure = ''
                for x in xrange(stemlength1):
                    pk_structure = pk_structure + '('
                for x in xrange(looplength1):
                    pk_structure = pk_structure + '.'
                for x in xrange(stemlength2):
                    pk_structure = pk_structure + '['
                for x in xrange(looplength2):
                    pk_structure = pk_structure + '.'
                for x in xrange(stemlength1):
                    pk_structure = pk_structure + ')'
                for x in xrange(looplength3):
                    pk_structure = pk_structure + '.'
                for x in xrange(stemlength2):
                    pk_structure = pk_structure + ']'
            else:
                energy = round(pk_not_filtered[key][0],2)
                # Now assemble the core pseudoknot structure with one interrupted stem            
                recursive_loop1 = pk_not_filtered[key][1]
                recursive_loop2 = pk_not_filtered[key][2]
                recursive_loop3 = pk_not_filtered[key][3]                
                looplength1 = k - (i + stemlength1)            
                looplength2 = (j - stemlength1 + 1) - (k + stemlength2)
                looplength3 = (l - stemlength2) - j 
                pk_seq = seq[int(i-1):int(l)]
                pk_structure = ''            
                # Case 1: stem S1 is interrupted
                if marker == 'iS1':
                    stem1 = i,j
                    structure_stem1 = functions.find_in_dic(bulge_internal_dic,stem1)[1]             
                    # Delete dangling ends ':'
                    structure_stem1 = structure_stem1.replace(':','')
                    pk_structure = pk_structure + structure_stem1                       
                    # Start of stem S2                                 
                    start = k - i               
                    for x in xrange(stemlength2):
                        pk_structure = pk_structure[0:start] + '[' + pk_structure[start+1:]
                        start = start + 1
                    for x in xrange(looplength3):
                        pk_structure = pk_structure + '.'                    
                    for x in xrange(stemlength2):
                        pk_structure = pk_structure + ']'                                
                # Case 2: stem S2 is interrupted, change brackets '(' to '[' and ')' to ']'
                if marker == 'iS2':
                    stem2 = k,l
                    structure_stem2 = functions.find_in_dic(bulge_internal_dic,stem2)[1]                   
                    # Delete dangling ends ':'
                    structure_stem2 = structure_stem2.replace(':','')
                    structure_stem2 = structure_stem2.replace('(','[')
                    structure_stem2 = structure_stem2.replace(')',']')                
                    pk_structure = pk_structure + structure_stem2
                    for x in xrange(looplength1):
                        pk_structure = '.' + pk_structure                
                    for x in xrange(stemlength1):
                        pk_structure = '(' + pk_structure
                    # End of stem S1
                    end = j-i
                    for x in xrange(stemlength1):
                        pk_structure = pk_structure[0:end] + ')' + pk_structure[end+1:]
                        end = end - 1
            # Now add recursive structure elements
            if recursive_loop1:
                for element in recursive_loop1:
                    element_length = element[2] + 1
                    start = element[0] - i
                    end = element[1] - i
                    if element[6] == 'hp':                                       
                        for counter in xrange(1,element_length):
                            pk_structure = pk_structure[0:start] + '(' + pk_structure[start+1:]
                            pk_structure = pk_structure[0:end] + ')' + pk_structure[end+1:]
                            start = start + 1
                            end = end - 1
                    elif element[6] == 'ib':
                        structure_ib = bulge_internal_dic[element[0],element[1]][1]                    
                        structure_ib = structure_ib.replace(':','') # Cut off dangling ends
                        pk_structure = pk_structure[0:start] + structure_ib + pk_structure[end+1:]                
                    elif element[6] == 'ml':
                        structure_ml = multiloops[element[0],element[1]][1]                    
                        structure_ml = structure_ml.replace(':','') # Cut off dangling ends
                        pk_structure = pk_structure[0:start] + structure_ml + pk_structure[end+1:]
            if recursive_loop2:
                for element in recursive_loop2:
                    element_length = element[2] + 1
                    start = element[0] - i
                    end = element[1] - i             
                    if element[6] == 'hp':                                       
                        for counter in xrange(1,element_length):
                            pk_structure = pk_structure[0:start] + '(' + pk_structure[start+1:]
                            pk_structure = pk_structure[0:end] + ')' + pk_structure[end+1:]
                            start = start + 1
                            end = end - 1
                    elif element[6] == 'ib':                        
                        structure_ib = bulge_internal_dic[element[0],element[1]][1]                    
                        structure_ib = structure_ib.replace(':','') # Cut off dangling ends
                        pk_structure = pk_structure[0:start] + structure_ib + pk_structure[end+1:]
                    elif element[6] == 'ml':
                        structure_ml = multiloops[element[0],element[1]][1]                    
                        structure_ml = structure_ml.replace(':','') # Cut off dangling ends
                        pk_structure = pk_structure[0:start] + structure_ml + pk_structure[end+1:]
            if recursive_loop3:
                for element in recursive_loop3:
                    element_length = element[2] + 1
                    start = element[0] - i
                    end = element[1] - i               
                    if element[6] == 'hp':                   
                        for counter in xrange(1,element_length):
                            pk_structure = pk_structure[0:start] + '(' + pk_structure[start+1:]
                            pk_structure = pk_structure[0:end] + ')' + pk_structure[end+1:]
                            start = start + 1
                            end = end - 1
                    elif element[6] == 'ib':                        
                        structure_ib = bulge_internal_dic[element[0],element[1]][1]
                        structure_ib = structure_ib.replace(':','') # Cut off dangling ends
                        pk_structure = pk_structure[0:start] + structure_ib + pk_structure[end+1:]
                    elif element[6] == 'ml':
                        structure_ml = multiloops[element[0],element[1]][1]                    
                        structure_ml = structure_ml.replace(':','') # Cut off dangling ends
                        pk_structure = pk_structure[0:start] + structure_ml + pk_structure[end+1:]                      
            pseudoknot = [i, l, energy, pk_seq, pk_structure]             
            pseudoknot_list.append(pseudoknot)                                          
    return pseudoknot_list    

def recursive_elements(recursive_loop, pk_structure, i, bulge_internal_dic, multiloops):
    for element in recursive_loop:
        element_length = element[2] + 1
        start = element[0] - i
        end = element[1] - i                
        if element[6] == 'hp':                                       
            for counter in xrange(1,element_length):
                pk_structure = pk_structure[0:start] + '(' + pk_structure[start+1:]
                pk_structure = pk_structure[0:end] + ')' + pk_structure[end+1:]
                start = start + 1
                end = end - 1
        elif element[6] == 'ib':
            structure_ib = bulge_internal_dic[element[0],element[1]][1]                    
            structure_ib = structure_ib.replace(':','') # Cut off dangling ends
            pk_structure = pk_structure[0:start] + structure_ib + pk_structure[end+1:]                
        elif element[6] == 'ml':
            structure_ml = multiloops[element[0],element[1]][1]                    
            structure_ml = structure_ml.replace(':','') # Cut off dangling ends
            pk_structure = pk_structure[0:start] + structure_ml + pk_structure[end+1:]
    return pk_structure
