/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.1
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name */
#define CMDLINE_PARSER_PACKAGE "Kinfold"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  int dangle_arg;	/**< @brief <0|1|2> set dangling end model to (none|normal|double) (default='2').  */
  char * dangle_orig;	/**< @brief <0|1|2> set dangling end model to (none|normal|double) original value given at command line.  */
  const char *dangle_help; /**< @brief <0|1|2> set dangling end model to (none|normal|double) help description.  */
  float Temp_arg;	/**< @brief simulation temperature (default='37').  */
  char * Temp_orig;	/**< @brief simulation temperature original value given at command line.  */
  const char *Temp_help; /**< @brief simulation temperature help description.  */
  char * Par_arg;	/**< @brief read energy-parameter-file.  */
  char * Par_orig;	/**< @brief read energy-parameter-file original value given at command line.  */
  const char *Par_help; /**< @brief read energy-parameter-file help description.  */
  int logML_flag;	/**< @brief use logarithmic multiloop energies instead of linear (default=on).  */
  const char *logML_help; /**< @brief use logarithmic multiloop energies instead of linear help description.  */
  int noShift_flag;	/**< @brief turn off shift-moves (default=off).  */
  const char *noShift_help; /**< @brief turn off shift-moves help description.  */
  int noLP_flag;	/**< @brief forbid structures with isolated base-pairs (default=off).  */
  const char *noLP_help; /**< @brief forbid structures with isolated base-pairs help description.  */
  char * seed_arg;	/**< @brief set random number seed specify 3 integers as int=int=int (default='clock').  */
  char * seed_orig;	/**< @brief set random number seed specify 3 integers as int=int=int original value given at command line.  */
  const char *seed_help; /**< @brief set random number seed specify 3 integers as int=int=int help description.  */
  float time_arg;	/**< @brief set maxtime of simulation (default='500').  */
  char * time_orig;	/**< @brief set maxtime of simulation original value given at command line.  */
  const char *time_help; /**< @brief set maxtime of simulation help description.  */
  int num_arg;	/**< @brief set number of trajectories (default='1').  */
  char * num_orig;	/**< @brief set number of trajectories original value given at command line.  */
  const char *num_help; /**< @brief set number of trajectories help description.  */
  int start_flag;	/**< @brief read start structure from stdin (otherwise use open chain) (default=off).  */
  const char *start_help; /**< @brief read start structure from stdin (otherwise use open chain) help description.  */
  int stop_flag;	/**< @brief read stop structure(s) from stdin (optherwise use MFE) (default=off).  */
  const char *stop_help; /**< @brief read stop structure(s) from stdin (optherwise use MFE) help description.  */
  int met_flag;	/**< @brief use Metropolis rule for rates (not Kawasaki rule) (default=off).  */
  const char *met_help; /**< @brief use Metropolis rule for rates (not Kawasaki rule) help description.  */
  int fpt_flag;	/**< @brief compute first passage time (stop when a stop-structure is reached) (default=on).  */
  const char *fpt_help; /**< @brief compute first passage time (stop when a stop-structure is reached) help description.  */
  float grow_arg;	/**< @brief grow chain every <float> time steps (default='0').  */
  char * grow_orig;	/**< @brief grow chain every <float> time steps original value given at command line.  */
  const char *grow_help; /**< @brief grow chain every <float> time steps help description.  */
  int glen_arg;	/**< @brief initial size of growing chain (default='15').  */
  char * glen_orig;	/**< @brief initial size of growing chain original value given at command line.  */
  const char *glen_help; /**< @brief initial size of growing chain help description.  */
  double phi_arg;	/**< @brief set phi value.  */
  char * phi_orig;	/**< @brief set phi value original value given at command line.  */
  const char *phi_help; /**< @brief set phi value help description.  */
  char * pbounds_arg;	/**< @brief specify 3 floats for phi_min, phi_inc, phi_max in the form <d1=d2=d3>.  */
  char * pbounds_orig;	/**< @brief specify 3 floats for phi_min, phi_inc, phi_max in the form <d1=d2=d3> original value given at command line.  */
  const char *pbounds_help; /**< @brief specify 3 floats for phi_min, phi_inc, phi_max in the form <d1=d2=d3> help description.  */
  char * log_arg;	/**< @brief set basename of log-file (default='kinout').  */
  char * log_orig;	/**< @brief set basename of log-file original value given at command line.  */
  const char *log_help; /**< @brief set basename of log-file help description.  */
  char * err_arg;	/**< @brief set basename of error-log-file.  */
  char * err_orig;	/**< @brief set basename of error-log-file original value given at command line.  */
  const char *err_help; /**< @brief set basename of error-log-file help description.  */
  int silent_flag;	/**< @brief no output to stdout (default=off).  */
  const char *silent_help; /**< @brief no output to stdout help description.  */
  int verbose_flag;	/**< @brief more information to stdout (default=off).  */
  const char *verbose_help; /**< @brief more information to stdout help description.  */
  int lmin_flag;	/**< @brief output only local minima to stdout (default=off).  */
  const char *lmin_help; /**< @brief output only local minima to stdout help description.  */
  float cut_arg;	/**< @brief output structures with E <= <float> to stdout (default='20').  */
  char * cut_orig;	/**< @brief output structures with E <= <float> to stdout original value given at command line.  */
  const char *cut_help; /**< @brief output structures with E <= <float> to stdout help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int dangle_given ;	/**< @brief Whether dangle was given.  */
  unsigned int Temp_given ;	/**< @brief Whether Temp was given.  */
  unsigned int Par_given ;	/**< @brief Whether Par was given.  */
  unsigned int logML_given ;	/**< @brief Whether logML was given.  */
  unsigned int noShift_given ;	/**< @brief Whether noShift was given.  */
  unsigned int noLP_given ;	/**< @brief Whether noLP was given.  */
  unsigned int seed_given ;	/**< @brief Whether seed was given.  */
  unsigned int time_given ;	/**< @brief Whether time was given.  */
  unsigned int num_given ;	/**< @brief Whether num was given.  */
  unsigned int start_given ;	/**< @brief Whether start was given.  */
  unsigned int stop_given ;	/**< @brief Whether stop was given.  */
  unsigned int met_given ;	/**< @brief Whether met was given.  */
  unsigned int fpt_given ;	/**< @brief Whether fpt was given.  */
  unsigned int grow_given ;	/**< @brief Whether grow was given.  */
  unsigned int glen_given ;	/**< @brief Whether glen was given.  */
  unsigned int phi_given ;	/**< @brief Whether phi was given.  */
  unsigned int pbounds_given ;	/**< @brief Whether pbounds was given.  */
  unsigned int log_given ;	/**< @brief Whether log was given.  */
  unsigned int err_given ;	/**< @brief Whether err was given.  */
  unsigned int silent_given ;	/**< @brief Whether silent was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int lmin_given ;	/**< @brief Whether lmin was given.  */
  unsigned int cut_given ;	/**< @brief Whether cut was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *gengetopt_args_info_full_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char * const *argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char * const *argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char * const *argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void cmdline_parser_print_full_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);

extern char *cmdline_parser_dangle_values[] ;	/**< @brief Possible values for dangle.  */


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
