import os
import math
import functions
    
# Task: Energy evaluation for pseudoknots in dictionary under energy model LongPK
def dic_longpks(pseudoknot_dic_longpk,matrix_stems,init,penalty):
    pseudoknot_dic_longpk_result = {}    
    for pk_stem in pseudoknot_dic_longpk:
        i, j, k, l = pk_stem[2], pk_stem[3], pk_stem[5], pk_stem[6]        
        stem1 = i, j        
        stemlength1 = pk_stem[4]
        stack_s1 = functions.find_in_dic(matrix_stems,stem1)[2]
        energy_s1 = functions.find_in_dic(matrix_stems,stem1)[3]                                              
        stem2 = k, l                
        stemlength2 = pk_stem[7]
        stack_s2 = functions.find_in_dic(matrix_stems,stem2)[2]             
        energy_s2 = functions.find_in_dic(matrix_stems,stem2)[3]            
            
        l1 = k - (i + stemlength1)
        l2 = (j - stemlength1 + 1) - (k + stemlength2) 
        l3 = (l - stemlength2) - j
        looplength = l1 + l2 + l3        
        entropy = penalty*(looplength)
        
        pk_energy = stack_s1 + stack_s2 + entropy + init
        if pk_energy < 0.0:            
            if pk_energy < energy_s1 and pk_energy < energy_s2:
                pseudoknot_dic_longpk_result[pk_stem] = pk_energy, stack_s1, stack_s2, l1, l2, l3, entropy, looplength
    return pseudoknot_dic_longpk_result

# Task: Energy re-evaluation for pseudoknots in dictionary under energy model LongPK
def pk_energy_reevaluation_long(pseudoknot_dic_longpk,matrix_stems,init,penalty):
    for pk_stem, values in pseudoknot_dic_longpk.items():
        list1 = values[1]
        list2 = values[2]
        list3 = values[3]
        if list1 or list2 or list3:
            i, j, k, l = pk_stem[2], pk_stem[3], pk_stem[5], pk_stem[6]
            stem1 = i, j        
            stemlength1 = pk_stem[4]
            stem2 = k, l                
            stemlength2 = pk_stem[7]  
            stack_s1 = values[0][1]
            stack_s2 = values[0][2]
            l1 = values[0][3]
            l2 = values[0][4]     
            l3 = values[0][5]                                                
            entropy_l1, energy_l1 = 0.0, 0.0
            entropy_l2, energy_l2 = 0.0, 0.0
            entropy_l3, energy_l3 = 0.0, 0.0            
            energy = stack_s1 + stack_s2    # Store stem energies for S1 plus S2
                        
            if list1:      # Calculate effective loop length 
                effective_looplength1 = l1                
                for item in list1:
                    effective_looplength1 = effective_looplength1 - (item[1]-item[0]+1)                    
                    effective_looplength1 = effective_looplength1 + 1   # Plus number of helices                     
                    energy_l1 = energy_l1 + item[5]                     # Add free energies
            else:
                effective_looplength1 = l1                       
            if list2:      # Calculate effective loop length        
                effective_looplength2 = l2                
                for item in list2:
                    effective_looplength2 = effective_looplength2 - (item[1]-item[0]+1)                         
                    effective_looplength2 = effective_looplength2 + 1   # Plus number of helices
                    energy_l2 = energy_l2 + item[5]                     # Add free energies
            else:
                effective_looplength2 = l2                            
            if list3:       # Calculate effective loop length      
                effective_looplength3 = l3
                for item in list3:
                    effective_looplength3 = effective_looplength3 - (item[1]-item[0]+1)                     
                    effective_looplength3 = effective_looplength3 + 1   # Plus number of helices
                    energy_l3 = energy_l3 + item[5]                     # Add free energies
            else:       
                effective_looplength3 = l3
                
            looplength = effective_looplength1 + effective_looplength2 + effective_looplength3
            entropy = penalty * looplength
            pk_energy = stack_s1 + stack_s2 + entropy + energy_l1 + energy_l2 + energy_l3 + init
            if pk_energy < values[0][0]:
                pseudoknot_dic_longpk[pk_stem] = pk_energy, values[1], values[2], values[3]
            else:
                energy = values[0][0]
                pseudoknot_dic_longpk[pk_stem] = energy, [], [], []                                           
        else:
            energy = values[0][0]
            pseudoknot_dic_longpk[pk_stem] = energy, values[1], values[2], values[3]
            
    return pseudoknot_dic_longpk
