import os
import math
import sys
import functions

# Function for finding nested intervals, given a right endpoint
# Outer stem is a hairpin loop
def find_nested(endpoint,candidate_list):
    only_hp_ib_ml = True
    result = []
    interval_index = endpoint[3]
    interval = candidate_list[interval_index-1]
    interval_left = interval[0]+interval[2]  
    interval_right = interval[1]-interval[2] 
    for compare_interval in candidate_list:
        if compare_interval[0] >= interval_left:                              
            if compare_interval[1] <= interval_right:
                # Special case for nested pseudoknot
                # Add one base to each side as a safeguard
                # {{{.(((..[[[.)))....]]].}}}
                if compare_interval[5] == 'pk':
                    if compare_interval[0] > interval_left:
                        if compare_interval[1] < interval_right:
                            result.append(compare_interval)
                            only_hp_ib_ml = False
                else:
                    result.append(compare_interval)                                                 
    return result, only_hp_ib_ml 

# Task: Maximum weight independent set using the set of structure elements and pseudoknots
def method(matrix_stems_mwis,pk_recursive_dic,bulge_internal_dic,multiloops):
    detected_pks, secondary_structures, mwis_dic, candidate_list = {}, {}, {}, []

    for stem, values in matrix_stems_mwis.iteritems():
        if values[3] < 0.0:
            element = (stem[0],stem[1],values[0],values[1],-1*round(values[3],2),"hp")
            candidate_list.append(element)    
    for pk_stem, pk_energy in pk_recursive_dic.iteritems():
        element = (pk_stem[0],pk_stem[1],pk_stem[4],pk_stem[7],-1*round(pk_energy[0],2),"pk",pk_stem[2],pk_stem[3],pk_stem[4],pk_stem[5],pk_stem[6],pk_stem[7],pk_stem[8])
        candidate_list.append(element)
    for stem, values in bulge_internal_dic.iteritems():
        element = (stem[0],stem[1],values[0],values[1],-1*round(values[2],2),"ib")
        candidate_list.append(element)
    for stem, values in multiloops.iteritems():
        element = (stem[0],stem[1],values[0],values[1],-1*round(values[2],2),"ml")
        candidate_list.append(element)

    if candidate_list:
        candidate_list.sort()
        sorted_endpoint_list = functions.create_sorted_endpointlist(candidate_list)
        
        for endpoint in sorted_endpoint_list:   # Scan sorted endpoints list         
            if endpoint[1] == 'r':              # If a right endpoint is scanned
                sorted_endpoint_list_recursive, nested = [], []
                index = endpoint[3]                       
                if candidate_list[index-1][5] == 'hp':
                    nested, only_hp_ib_ml = find_nested(endpoint,candidate_list)                
                    if nested and only_hp_ib_ml == False:  # MWIS on the set of nested structure elements                  
                        endpoint_list_recursive = functions.create_sorted_endpointlist(nested)
                        result = functions.MWIS(nested, endpoint_list_recursive)
                        interval = candidate_list[index-1]
                        energy = candidate_list[index-1][4]
                        for element in result:    # Free energy sum
                            energy = energy + element[4]
                        # Store updated free energy for outer stem
                        candidate_list[index-1] = (interval[0],interval[1],interval[2],interval[3],energy,interval[5])                    
                        stem = interval[0],interval[1],interval[2]
                        # Store inner structure elements in dictionary
                        mwis_dic[stem] = result

        # Main MWIS calculation
        sorted_endpoint_list_recursive = functions.create_sorted_endpointlist(candidate_list)
        result = functions.MWIS(candidate_list, sorted_endpoint_list_recursive)    
        energy = 0.0
        for j in xrange(len(result)):
            energy = energy + result[j][4]

        # Search for detected pseudoknots
        for element in result:
            if element[5] == 'pk':
                detected_pks[element] = element[4]
            if element[5] == 'hp' or element[5] == 'ib' or element[5] == 'ml':
                secondary_structures[element] = element[4]                
            if element[5] == 'hp':  # Hairpin loop can have nested elements
                detected_pks, secondary_structures = print_recursive(element, mwis_dic, detected_pks, secondary_structures)    
    return mwis_dic, detected_pks, secondary_structures

# Task : Given the MWIS result, look for pseudoknots recursively
# Pseudoknots can be nested in hairpin loops.
def print_recursive(element, mwis_dic, detected_pks, secondary_structures):
    structure = element[0], element[1], element[2]
    if functions.find_in_dic(mwis_dic, structure) != 0.0:
        stem_internal_list = mwis_dic[element[0], element[1], element[2]]
        for item in stem_internal_list:
            if item[5] == 'pk':
                detected_pks[item] = item[4]
            if item[5] == 'hp' or item[5] == 'ib' or item[5] == 'ml': 
                secondary_structures[item] = item[4]                
            if item[5] == 'hp':
                substructure = item[0], item[1], item[2]
                if functions.find_in_dic(mwis_dic, substructure) != 0.0:
                    detected_pks, secondary_structures = print_recursive(substructure, mwis_dic, detected_pks, secondary_structures) 
    return detected_pks, secondary_structures   

# Task: Print structures for pseudoknots with both regular and interrupted stems
def pk_structures(seq, detected_pks, matrix_stems, stems_shortened_dic, bulge_internal_dic, multiloops, pk_recursive_dic, pk_dic_ib):
    pseudoknot_list = []    
    for pk in sorted(set(detected_pks)):
        i, j, stemlength1 = pk[6], pk[7], pk[8]        
        k, l, stemlength2 = pk[9], pk[10], pk[11]
        marker = pk[12]
        key = i, l, i, j, stemlength1, k, l, stemlength2, marker                            
        # Find the recursive structure elements            
        if marker == 'r':            
            recursive_loop1 = pk_recursive_dic[key][1]
            recursive_loop2 = pk_recursive_dic[key][2]
            recursive_loop3 = pk_recursive_dic[key][3]
            # Now assemble the core pseudoknot structure with regular stems
            looplength1 = k - (i + stemlength1)            
            looplength2 = (j - stemlength1 + 1) - (k + stemlength2)
            looplength3 = (l - stemlength2) - j
            pk_seq = seq[int(i-1):int(l)]
            pk_structure = ''
            for x in xrange(stemlength1):
                pk_structure = pk_structure + '('
            for x in xrange(looplength1):
                pk_structure = pk_structure + '.'
            for x in xrange(stemlength2):
                pk_structure = pk_structure + '['
            for x in xrange(looplength2):
                pk_structure = pk_structure + '.'
            for x in xrange(stemlength1):
                pk_structure = pk_structure + ')'
            for x in xrange(looplength3):
                pk_structure = pk_structure + '.'
            for x in xrange(stemlength2):
                pk_structure = pk_structure + ']'                
        else:
            # Now assemble the core pseudoknot structure with one interrupted stem            
            recursive_loop1 = pk_dic_ib[key][1]
            recursive_loop2 = pk_dic_ib[key][2]
            recursive_loop3 = pk_dic_ib[key][3]                
            looplength1 = k - (i + stemlength1)            
            looplength2 = (j - stemlength1 + 1) - (k + stemlength2)
            looplength3 = (l - stemlength2) - j 
            pk_seq = seq[int(i-1):int(l)]
            pk_structure = ''            
            # Case 1: stem S1 is interrupted
            if marker == 'iS1':
                stem1 = i,j
                structure_stem1 = functions.find_in_dic(bulge_internal_dic,stem1)[1]             
                # Delete dangling ends ':'
                structure_stem1 = structure_stem1.replace(':','')
                pk_structure = pk_structure + structure_stem1                       
                # Start of stem S2                                 
                start = k-i               
                for x in xrange(stemlength2):
                    pk_structure = pk_structure[0:start] + '[' + pk_structure[start+1:]
                    start = start + 1
                for x in xrange(looplength3):
                    pk_structure = pk_structure + '.'                    
                for x in xrange(stemlength2):
                    pk_structure = pk_structure + ']'                                
            # Case 2: stem S2 is interrupted, change brackets '(' to '[' and ')' to ']'
            if marker == 'iS2':
                stem2 = k,l
                structure_stem2 = functions.find_in_dic(bulge_internal_dic,stem2)[1]                   
                # Delete dangling ends ':'
                structure_stem2 = structure_stem2.replace(':','')
                structure_stem2 = structure_stem2.replace('(','[')
                structure_stem2 = structure_stem2.replace(')',']')                
                pk_structure = pk_structure + structure_stem2
                for x in xrange(looplength1):
                    pk_structure = '.' + pk_structure                
                for x in xrange(stemlength1):
                    pk_structure = '(' + pk_structure
                # End of stem S1
                end = j-i
                for x in xrange(stemlength1):
                    pk_structure = pk_structure[0:end] + ')' + pk_structure[end+1:]
                    end = end - 1
        # Now add recursive structure elements
        if recursive_loop1:
            for element in recursive_loop1:
                element_length = element[2] + 1
                start = element[0] - pk[6] 
                end = element[1] - pk[6]                 
                if element[6] == 'hp':                                       
                    for counter in xrange(1,element_length):
                        pk_structure = pk_structure[0:start] + '(' + pk_structure[start+1:]
                        pk_structure = pk_structure[0:end] + ')' + pk_structure[end+1:]
                        start = start + 1
                        end = end - 1
                elif element[6] == 'ib':
                    structure_ib = bulge_internal_dic[element[0],element[1]][1]                    
                    structure_ib = structure_ib.replace(':','') # Cut off dangling ends
                    pk_structure = pk_structure[0:start] + structure_ib + pk_structure[end+1:]                
                elif element[6] == 'ml':
                    structure_ml = multiloops[element[0],element[1]][1]                    
                    structure_ml = structure_ml.replace(':','') # Cut off dangling ends
                    pk_structure = pk_structure[0:start] + structure_ml + pk_structure[end+1:]                      
        if recursive_loop2:
            for element in recursive_loop2:
                element_length = element[2] + 1
                start = element[0] - pk[6] 
                end = element[1] - pk[6]                 
                if element[6] == 'hp':                                       
                    for counter in xrange(1,element_length):
                        pk_structure = pk_structure[0:start] + '(' + pk_structure[start+1:]
                        pk_structure = pk_structure[0:end] + ')' + pk_structure[end+1:]
                        start = start + 1
                        end = end - 1
                elif element[6] == 'ib':                        
                    structure_ib = bulge_internal_dic[element[0],element[1]][1]                    
                    structure_ib = structure_ib.replace(':','') # Cut off dangling ends
                    pk_structure = pk_structure[0:start] + structure_ib + pk_structure[end+1:]
                elif element[6] == 'ml':
                    structure_ml = multiloops[element[0],element[1]][1]                    
                    structure_ml = structure_ml.replace(':','') # Cut off dangling ends
                    pk_structure = pk_structure[0:start] + structure_ml + pk_structure[end+1:]                                            
        if recursive_loop3:
            for element in recursive_loop3:
                element_length = element[2] + 1
                start = element[0] - pk[6] 
                end = element[1] - pk[6]                  
                if element[6] == 'hp':                   
                    for counter in xrange(1,element_length):
                        pk_structure = pk_structure[0:start] + '(' + pk_structure[start+1:]
                        pk_structure = pk_structure[0:end] + ')' + pk_structure[end+1:]
                        start = start + 1
                        end = end - 1
                elif element[6] == 'ib':                        
                    structure_ib = bulge_internal_dic[element[0],element[1]][1]
                    structure_ib = structure_ib.replace(':','') # Cut off dangling ends
                    pk_structure = pk_structure[0:start] + structure_ib + pk_structure[end+1:]
                elif element[6] == 'ml':
                    structure_ml = multiloops[element[0],element[1]][1]                    
                    structure_ml = structure_ml.replace(':','') # Cut off dangling ends
                    pk_structure = pk_structure[0:start] + structure_ml + pk_structure[end+1:]                      
                    
        pseudoknot = [pk[0], pk[1], -1*float(pk[4]), pk[5], pk_seq, pk_structure]             
        pseudoknot_list.append(pseudoknot)                                          
    return pseudoknot_list

# Task: assemble global structure from MWIS result. 
def assemble_global_structure(seq, secondary_structures, pseudoknot_list):

    predicted_global_structure = []
    for i in xrange(len(seq)):
        predicted_global_structure.append('.')

    # Insert secondary structure elements
    if secondary_structures:        
        for element, energy in sorted(secondary_structures.items()):
            if element[5] == 'hp':
                structure = []  # Build stem structure for hairpin loop
                for i in xrange(element[1] - element[0] + 1):
                    structure.append('.')                            
                for i in xrange(element[2]):    
                    structure[i] = '('
                    structure[len(structure) - i - 1] = ')'
                predicted_global_structure[element[0]-1:element[1]] = structure                
            else:               # Insert bulge loop, internal loop and multiloop structures
                structure = element[3].replace(':','')                        
                predicted_global_structure[element[0]-1:element[1]] = list(structure)
                
    # Insert detected pseudoknots and kissing hairpins
    if pseudoknot_list:
        for pk in pseudoknot_list:                
            predicted_global_structure[pk[0]-1:pk[1]] = list(pk[5])

    predicted_global_structure = ''.join(predicted_global_structure)        
        
    return predicted_global_structure
