import os
import math
import functions

# Task: Construct recursive H-type pseudoknots with MWIS
def recursive_pk(matrix_stems,bulge_internal_dic,multiloops,pk_core_dic):
    for pk in pk_core_dic:      
        candidate_list1, candidate_list2, candidate_list3 = [], [], []
        candidate_list1_positive, candidate_list2_positive, candidate_list3_positive = [], [], []
        loop1_start = pk[2]+pk[4] 
        loop1_end = pk[5]-1       
        l1 = loop1_end - loop1_start + 1        
        loop2_start = pk[5]+pk[7] 
        loop2_end = pk[3]-pk[4]
        l2 = loop2_end - loop2_start + 1           
        loop3_start = pk[3]+1     
        loop3_end = pk[6]-pk[7]
        l3 = loop3_end - loop3_start + 1        
        # Look for recursive candidates in loops
        if l1 >= 9 or l2 >= 9 or l3 >= 9:
            for stem, values in matrix_stems.items():
                if stem[0] >= loop1_start and stem[1] <= loop1_end:                  
                    # Safeguard against sterically infeasible configuration, add one base at either side of the loop region 
                    if stem[0] > loop1_start or stem[1] < loop1_end:                        
                        if values[3] <= 0.0:
                            element = (stem[0],stem[1],values[0],values[1],-1*round(values[3],2),values[3],"hp")
                            candidate_list1.append(element)
                        else:
                            element = (stem[0],stem[1],values[0],values[1],1.0/round(values[3],2),values[3],"hp")
                            candidate_list1_positive.append(element)                            
                if stem[0] >= loop2_start and stem[1] <= loop2_end:                       
                    if values[3] <= 0.0:
                        element = (stem[0],stem[1],values[0],values[1],-1*round(values[3],2),values[3],"hp")
                        candidate_list2.append(element)
                    else:
                        element = (stem[0],stem[1],values[0],values[1],1.0/round(values[3],2),values[3],"hp")
                        candidate_list2_positive.append(element)                     
                if stem[0] >= loop3_start and stem[1] <= loop3_end:    
                    # Safeguard against sterically infeasible configuration, add one base at either side of the loop region                    
                    if stem[0] > loop3_start or stem[1] < loop3_end:                               
                        if values[3] <= 0.0:
                            element = (stem[0],stem[1],values[0],values[1],-1*round(values[3],2),values[3],"hp")
                            candidate_list3.append(element)
                        else:
                            element = (stem[0],stem[1],values[0],values[1],1.0/round(values[3],2),values[3],"hp")
                            candidate_list3_positive.append(element)                         
            for stem_ib, values_ib in bulge_internal_dic.items():
                if stem_ib[0] >= loop1_start and stem_ib[1] <= loop1_end:
                    # Safeguard against sterically infeasible configuration, add one base at either side of the loop region
                    if stem_ib[0] > loop1_start or stem_ib[1] < loop1_end:       
                        element = (stem_ib[0],stem_ib[1],values_ib[0],0.0,-1*round(values_ib[2],2),values_ib[2],"ib")
                        candidate_list1.append(element)
                if stem_ib[0] >= loop2_start and stem_ib[1] <= loop2_end: 
                    element = (stem_ib[0],stem_ib[1],values_ib[0],0.0,-1*round(values_ib[2],2),values_ib[2],"ib")
                    candidate_list2.append(element)                    
                if stem_ib[0] >= loop3_start and stem_ib[1] <= loop3_end:
                    # Safeguard against sterically infeasible configuration, add one base at either side of the loop region
                    if stem_ib[0] > loop3_start or stem_ib[1] < loop3_end: 
                        element = (stem_ib[0],stem_ib[1],values_ib[0],0.0,-1*round(values_ib[2],2),values_ib[2],"ib")                    
                        candidate_list3.append(element)                        
            for stem_ml, values_ml in multiloops.items():
                if stem_ml[0] >= loop1_start and stem_ml[1] <= loop1_end:
                    # Safeguard against sterically infeasible configuration, add one base at either side of the loop region
                    if stem_ml[0] > loop1_start or stem_ml[1] < loop1_end:  
                        element = (stem_ml[0],stem_ml[1],values_ml[0],0.0,-1*round(values_ml[2],2),values_ml[2],"ml")
                        candidate_list1.append(element)
                if stem_ml[0] >= loop2_start and stem_ml[1] <= loop2_end: 
                    element = (stem_ml[0],stem_ml[1],values_ml[0],0.0,-1*round(values_ml[2],2),values_ml[2],"ml")
                    candidate_list2.append(element)                     
                if stem_ml[0] >= loop3_start and stem_ml[1] <= loop3_end:
                    # Safeguard against sterically infeasible configuration, add one base at either side of the loop region
                    if stem_ml[0] > loop3_start or stem_ml[1] < loop3_end:  
                        element = (stem_ml[0],stem_ml[1],values_ml[0],0.0,-1*round(values_ml[2],2),values_ml[2],"ml")
                        candidate_list3.append(element)                     
                    
        energy1, energy2, energy3 = 0.0, 0.0, 0.0
        result1, result2, result3 = [], [], []
        if candidate_list1:
            result1 = recursive_pk_mwis(pk,candidate_list1)
        else:
            if candidate_list1_positive:          
                result1 = recursive_pk_mwis(pk,candidate_list1_positive)
        if candidate_list2:          
            result2 = recursive_pk_mwis(pk,candidate_list2)
        else:
            if candidate_list2_positive:       
                result2 = recursive_pk_mwis(pk,candidate_list2_positive)        
        if candidate_list3:
            result3 = recursive_pk_mwis(pk,candidate_list3)
        else:
            if candidate_list3_positive:
                result3 = recursive_pk_mwis(pk,candidate_list3_positive)            
            
        pseudoknot_energy = pk_core_dic[pk]
        pk_core_dic[pk] = pseudoknot_energy, result1, result2, result3
        
    return pk_core_dic

# Task: MWIS calculation for recursive H-type pseudoknot construction
def recursive_pk_mwis(pk,candidate_list):
    candidate_list.sort()
    sorted_endpoint_list = functions.create_sorted_endpointlist(candidate_list)
    result = functions.MWIS(candidate_list, sorted_endpoint_list)
    return result

# Task: Scan pseudoknot dictionary and create three new dictionaries,
# according to loop sizes, including recursive elements from loops
def pk_dic_scan_recursive(pk_core_dic,matrix_stems):
    pseudoknot_dic_cc06, pseudoknot_dic_cc09, pseudoknot_dic_longpk = {}, {}, {}
    for pk_stem in pk_core_dic:
        i, j, k, l = pk_stem[2], pk_stem[3], pk_stem[5], pk_stem[6]        
        stem1 = i, j        
        s1_length = pk_stem[4]
        stem2 = k, l                
        s2_length = pk_stem[7]
                                   
        l1 = k - (i + s1_length)
        l2 = (j - s1_length + 1) - (k + s2_length)
        l3 = (l - s2_length) - j

        if l2 <= 1:            
            pseudoknot_dic_cc06[pk_stem] = pk_core_dic[pk_stem]
        else:
            if l2 < 7: 
                pseudoknot_dic_cc09[pk_stem] = pk_core_dic[pk_stem]
            else:
                pseudoknot_dic_longpk[pk_stem] = pk_core_dic[pk_stem]
    return pseudoknot_dic_cc06,pseudoknot_dic_cc09,pseudoknot_dic_longpk

# Task: Filter pseudoknots with high free energy
def pk_filter(pk_recursive_dic):    
    for pk in sorted(set(pk_recursive_dic)):        
        if pk_recursive_dic[pk][0] >= -5.25:
            del pk_recursive_dic[pk]
        else:
            length = pk[1]-pk[0]+1
            if (pk_recursive_dic[pk][0]/length) > -0.25:
                del pk_recursive_dic[pk]                
    return pk_recursive_dic
